///////////////////////////////////////////////////////////
//  LedDrv.cpp
//  Implementation of the Class LedDrv
//  Created on:      2025/09/05 11:30:57
//  Original author: daisu
///////////////////////////////////////////////////////////

#include "LedDrv.h"

#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "driver/gpio.h"


namespace hw_handler {
	
/* LEDポートの定義 */
#define LED_01	(gpio_num_t)16
#define LED_02	(gpio_num_t)17

/* LEDの点灯と消灯の定義 */
#define L_ON	0
#define L_OFF	1
	
LedDrv::LedDrv(){

	/* LED1の初期化*/
    gpio_reset_pin(LED_01); 
    gpio_set_direction(LED_01, GPIO_MODE_OUTPUT); 
	gpio_set_level(LED_01, L_OFF);		/* 消灯 */

	/* LED2の初期化*/
    gpio_reset_pin(LED_02); 
    gpio_set_direction(LED_02, GPIO_MODE_OUTPUT); 
	gpio_set_level(LED_02, L_OFF);		/* 消灯 */
}



LedDrv::~LedDrv(){

}





void LedDrv::on(int bit){
	if (bit & 0x01) {
		gpio_set_level(LED_01, L_ON);
	}
	if (bit & 0x02) {
		gpio_set_level(LED_02, L_ON);
	}	
}


void LedDrv::off(){

	gpio_set_level(LED_01, L_OFF);
	gpio_set_level(LED_02, L_OFF);
}
}