///////////////////////////////////////////////////////////
//  SwDrv.cpp
//  Implementation of the Class SwDrv
//  Created on:      2025/09/05 11:43:39
//  Original author: daisu
///////////////////////////////////////////////////////////

#include "SwDrv.h"


/* esp-idf標準ライブラリ */
#include "driver/gpio.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"

namespace hw_handler {
	
/* マクロ・列挙体の定義 */
/* トグルスイッチの定義 */
#define SW_01	(gpio_num_t)32
#define SW_02	(gpio_num_t)33

SwDrv::SwDrv(){

	/* トグルスイッチ１の初期化 */
    gpio_reset_pin(SW_01); 
    gpio_set_direction(SW_01, GPIO_MODE_INPUT); 
    gpio_pullup_en(SW_01); // Pullup enable
	/* トグルスイッチ２の初期化 */
    gpio_reset_pin(SW_02); 
    gpio_set_direction(SW_02, GPIO_MODE_INPUT); 
    gpio_pullup_en(SW_02); // Pullup enable
}



SwDrv::~SwDrv(){

}





int SwDrv::read(){

	unsigned char sw01;
	unsigned char sw02;
	int data;
	
	/* スイッチの状態を読み込む */
	sw01 = (unsigned char)gpio_get_level(SW_01);
	sw02 = (unsigned char)gpio_get_level(SW_02);
	data = sw01 | (sw02 << 1);
	
	return data;
}
}