// ========================================================
// File    : BlinkApp.cpp [ba]
// Role    : LED blink application
// Date    : 2026.02.10
// Author  : Ikinati-kun
// ========================================================

// pR|[lg

// R|[lg
#include "BlinkApp.h"

// define}N/֐}N
#define LED2_on	0x20			// LED2(p75)_ 
#define LED3_on	0x10			// LED3(p74)_ 
#define LED_off	0x00			// LED 
#define LED_on  0x30			// LED2_ 

// ϐ̒`
volatile unsigned char p7;		// gOXCb`
volatile unsigned char p8;		// LED

// vg^Cv錾
void ba_wait_loop();

// --- functions (extern)
// ========================================================
// Name       : bs_run
// Function   : LED blink execution
// Parameters : none
// Return     : none
// notes      : 
// ========================================================
void ba_run(void)
{
	unsigned char data;

	for (;;)
	{
		data = 0x03 & p8;				// XCb`̏Ԃǂ݂

		switch (data) {
		case 0x00:						// 
			p7 = LED_off;
			break;
		case 0x01:						// ݂ɓ_
			do {
				p7 = LED2_on;			// LED2_
				ba_wait_loop();			// ԑ҂i\tgEGCgj
				p7 = LED3_on;			// LED3_
				ba_wait_loop();			// ԑ҂i\tgEGCgj
				data = 0x03 & p8;		// XCb`̏Ԃǂ݂
			} while (data == 0x01);
			p7 = LED_off;
			break;
		case 0x02:						// Qɓ_
			do {
				
				p7 = LED_on;			// LED2_
				ba_wait_loop();			// ԑ҂i\tgEGCgj
				p7 = LED_off;			// LED
				ba_wait_loop();			// ԑ҂i\tgEGCgj
				data = 0x03 & p8;		// XCb`̏Ԃǂ݂
			} while (data == 0x02);
			p7 = LED_off;
			break;
		case 0x03:						// 337q̃Y
			do {
				unsigned long j;
				for (j = 0;j < 3;j++) {
					p7 = LED2_on;		// LED2_
					ba_wait_loop();		// ԑ҂i\tgEGCgj
					p7 = LED_off;		// LED
					ba_wait_loop();		// ԑ҂i\tgEGCgj
				}
				for (j = 0;j < 3;j++) {
					p7 = LED3_on;		// LED3_	
					ba_wait_loop();		// ԑ҂i\tgEGCgj
					p7 = LED_off;		// LED
					ba_wait_loop();		// ԑ҂i\tgEGCgj
				}
				for (j = 0;j < 7;j++) {
					p7 = LED_on;		// LEDQ_
					ba_wait_loop();		// ԑ҂i\tgEGCgj
					p7 = LED_off;		// LED
				}
				data = 0x03 & p8;		// XCb`̏Ԃǂ݂
			} while (data == 0x03);
			p7 = LED_off;
			break;
		}
	}

	return;
}

// --- functions (static)
// ========================================================
// Name       : ba_wait_loop
// Function   : delay
// Parameters : none
// Return     : none
// notes      : 
// ========================================================
void ba_wait_loop(void) {
	unsigned long i;

	for (i = 0xfffffff;;) {	// ԑ҂(\tgEGCgj
		i--;
		if (i == 0) break;
	}
	return;
}
			
