/*----------------------------------------------------------------------*/
/*t@CF	PwmDriver.c												*/
/*	  eF	PWMo̓hCo[iT[{[^pj					 	*/
/*	  tF	2022.10.03												*/
/*	쐬ҁF	b-slash													*/
/*----------------------------------------------------------------------*/
/*** ATSTASK Pwm ***/
/* pwb_ */
#include "driver/gpio.h"

/* wb_ */
#include	"PwmDriver.h"

/* T[{[^̒萔` */
#define PWM_CYCLE	2000		/* 20msec(50Hz) PWMi10secPʁj */

/* ϐ` */
static unsigned int pwm_port_no;			/* o͐IO|[gԍ */
/* pwmϐ */
static unsigned int pwm_frame_counter;	/* PWM20msect[̃JE^[ */
static unsigned int pwm_on_width;		/* PWM̃I */
static unsigned int pwm_on_counter;		/* ĨJE^[ */
	
/* vg^Cv錾 */

/***************************************
 * ́Fsmgr_pwm_init
 * FPWMhCo[
 * Funsigned int port IO|[gԍ
 * ߂lFȂ
 ***************************************/
void smgr_init_pwm(unsigned int port) {
	
	/* IO|[gԍ̃Zbg */
	pwm_port_no = port;
	
	/* T[{[^HW̏ */
	gpio_reset_pin(pwm_port_no); 
    gpio_set_direction(pwm_port_no, GPIO_MODE_OUTPUT); 
	
	/* [^o̓|[g̏ */
	gpio_set_level(pwm_port_no, 0);
	
	
	/* PWMϐ̏ */
	pwm_frame_counter = 0;
	pwm_on_width = 0;		/* PWM̃I */
	pwm_on_counter = 0;
	
	return;
}

/***************************************
 * ́Fsmgr_write_pwm_width
 * Fo͐|[gƃpX̐ݒ
 * Funsigned int pulse_duty; pX(0-255)
 * ߂lFȂ
 ***************************************/
void smgr_write_pwm_width(unsigned int width) {
	
	/* pXωPWMo */
	if (pwm_on_width != width) {
		/* ݃pX̍XV */
		pwm_on_width = width;
	}
	return;
}

/***************************************
 * ́Fcmgr_urrent_width
 * F݂̃pX擾
 * FȂ
 * ߂lFunsigned int pwm_on_width; pX
 ***************************************/
unsigned int smgr_current_width(void) {
	
	return pwm_on_width;
}

/***************************************
 * ́Fsmgr_output_pwm
 * FPWMo͂(10sec݂Ă΂遚)
 * FȂ
 * ߂lFȂ
 ***************************************/
void smgr_output_pwm(void) {
	if (pwm_on_width != 0) {
		/* PWM20msect[ */
		if (pwm_frame_counter++ >=  PWM_CYCLE) {	/* 2000JEg */
			gpio_set_level(pwm_port_no, 1);
			/* pwmONpX̐ݒ */
			pwm_on_counter = 0;
			pwm_frame_counter = 0;
		}
		
		/* PWM̃pXI (10sec) */
		if (pwm_on_counter++ >= pwm_on_width) {
			gpio_set_level(pwm_port_no, 0);
		}
	}
	
	return;
}
