/*----------------------------------------------------------------------*/
/*t@CF	SonarSensor.c											*/
/*	  eF	gZThCo								 	*/
/*	  tF	2022.10.03												*/
/*	쐬ҁF	b-slash													*/
/*----------------------------------------------------------------------*/
/*** ATSTASK Sonar ***/
/* pwb_ */

/* wb_ */
#include	"SonarSensor.h"

#include "driver/gpio.h"

/* HW|[g̒` */
/* gZT̃gKPINƃGR[PIN */
#define GPIO_TRIG 14
#define GPIO_ECHO 13

#define SONAR_TICK	10	/* 10secŔ˃JEg */

/* ^C}[ݎ */
#define TIMER_CYCLE 10		/* secI[_ */

/* 񋓑̂̒` */
/* gZT̔˕̌vԂ̗񋓑 */
typedef enum
{
	eECHO_READY = 0,
	eECHO_ON,		/* pXƎˁiTrigsONj */
	eECHO_MEASURING,/* ˑ҂iECHOsONj */
	eECHO_FIX		/* miECHOsOFFj */
} echo_state_t;


/* ϐ` */
/* gZT[ϐ */
static int trig_on;				/* gK */
static echo_state_t echo_sts;
static int echo_counter;	/* ECHOs̃IJEg */
static int echo_width;		/* ECHO̊mI */

/* vg^Cv錾 */
static void smgr_reset_echo(void);	/* gZTϐ̏ */

/***************************************
 * ́Fsmgr_init_sonar
 * FgZT[
 * FȂ
 * ߂lFȂ
 ***************************************/
void smgr_init_sonar(void) {
	
	/* gZT[HW̏ */
    gpio_reset_pin(GPIO_TRIG); 
    gpio_set_direction(GPIO_TRIG, GPIO_MODE_OUTPUT);
	
    gpio_reset_pin(GPIO_ECHO); 
    gpio_set_direction(GPIO_ECHO, GPIO_MODE_INPUT); 
    gpio_pullup_en(GPIO_ECHO); // Pullup enable
	
	/* gZT[̏ */
	trig_on = 0;
	smgr_reset_echo();
	
	return;
}

/***************************************
 * ́Fss_reset_echo
 * FgZT[ϐ̏
 * FȂ
 * ߂lFȂ
 ***************************************/
static void smgr_reset_echo() {
	echo_sts = eECHO_READY;
	echo_counter = 0;	/* ECHOs̃IJEg */
	echo_width = 0;		/* ECHO̊mIi0͔̎˂Ȃj */
	
	return;
}

/***************************************
 * ́Fsmgr_get_pulsewidth
 * FgZT̔˕̎擾
 * FȂ 
* ߂lFecho_width Ǝ˂甽˂܂ł̃pX
 ***************************************/
int smgr_get_pulsewidth(void) {
	
	int latest_echo = echo_width;
	
	trig_on = 1;
	smgr_reset_echo();
	
	return (latest_echo);
}

/***************************************
 * ́Fsmgr_trig_echo
* FgZT[ł̋vi10sec݂Ă΂j
 * FȂ
 * ߂lFȂ
 ***************************************/
void smgr_trig_echo(void) {
	/* gZT[TrigI */
	if (trig_on == 1){
		gpio_set_level(GPIO_TRIG, 1);
		trig_on = 2;
	} else if (trig_on == 2) {	
		gpio_set_level(GPIO_TRIG, 0);
		trig_on = 0;
		echo_sts = eECHO_ON;
	}
 	
 	/* gZT[ECHȌԑJ */
 	switch (echo_sts) {
 	case eECHO_READY:		/* v\ */
 		/* Ȃ */
 		break;
 	case eECHO_ON:			/* v҂ */
 		if(gpio_get_level(GPIO_ECHO)){		/* ƎˊJn */
 			echo_sts = eECHO_MEASURING;
 		} else {
			/* Ȃ */
		}
 		break;
 	case eECHO_MEASURING:	/* ̌v */
 		echo_counter++;						/* ̃JEgAbv */
 		if(!gpio_get_level(GPIO_ECHO)){		/* ˎM */
 			echo_sts = eECHO_FIX;
 		} else {
			/* Ȃ */
		}
 		break;
 	case eECHO_FIX:			/* ̊m */
 		echo_sts = eECHO_READY;
 		echo_width = echo_counter*(TIMER_CYCLE/SONAR_TICK);
 		echo_counter = 0;
 		break;
 	default:
 		/* Ȃ */
 		break;
 	}
}
