/*----------------------------------------------------------------------*/
/*t@CF	GrgOperation.c	[go]									*/
/*	  eF	K[W~Av									 	*/
/*	  tF	2022.10.03												*/
/*	쐬ҁF	Kouzou-san												*/
/*----------------------------------------------------------------------*/
/*** ATSTASK MainTask ***/
/* pwb_ */
#include "../../ctrl/DoorMove/CmdAcceptor.h"
#include "../../ctrl/DoorMove/OpenClosejudge.h"
#include "../../ctrl/DoorMove/UpDownControl.h"
#include "../../facade/LightDisplay/DispStatus.h"

/* wb_ */
#include	"GrgOperation.h"

/* 񋓑̂̒` */
/* K[W̌ݏԂ̗񋓑 */
typedef enum {
	eGRG_READY = 0,		/* 쓮\ */
	eGRG_MOVING,		/* 쓮 */
	eGRG_SUSPEND,		/* ꎞ~ */
	eGRG_STOP			/* ~iً}~j */
} garage_state_t;

/* ϐ` */
static garage_state_t garage_status;	/* K[W̌ݏ */

/* vg^Cv錾 */
static void go_rcvOpenClose(ope_kind_t);
static void go_dispStatus(void);

/***************************************
 * ́Fgo_init
 * FAvԂ̏
 * FȂ
 * ߂lFȂ
 ***************************************/
void go_init(void) {
	/* R}h󗝂̏ */
	ca_init();
	
	/* Jf̏ */
	oj_init();
	
	/* K[W̏ */
	uc_init();
	
	/* ԕϐ */
	garage_status = eGRG_READY;
	
	/* \̏ */
	ds_init();
	
	return;
}

/***************************************
 * ́Fgo_run
 * FK[WJ̔fƊJwisj
 * FȂ
 * ߂lFȂ
 ***************************************/
void go_run(void) {
	/* C^[bNXCb`̊mF */
	ca_chkLock();
	/* L[͂̎M */
	cmd_kind_t cmd = ca_rcvCommand();
	
	/* I[vN[Y̔f */
	ope_kind_t ope = oj_judgeOpenClose(cmd);
	if ((ope == eOPE_OPEN) || (ope == eOPE_CLOSE)) {
		/* Jwɏ] */
		go_rcvOpenClose(ope);
	}
	
	/* 쓮ł΃hAJ */
	if (garage_status == eGRG_MOVING) {
		uc_moveDoor();		/* hAJs */
	}
	
	/* ݏԂ̍XV */
	go_dispStatus();	/* ݏԂ̕\ */
	
	return;
}

/***************************************
 * ́Fgo_rcvOpenClose
 * FJwɏ]
 * FȂ
 * ߂lFȂ
 ***************************************/
static void go_rcvOpenClose(ope_kind_t ope) {
	
	switch (garage_status) {
	case eGRG_READY:
	case eGRG_STOP:
		/* 쓮\ً}~쓮Ԃ */
		garage_status = eGRG_MOVING;
		/* K[WhÅJw */
		uc_operateDoor(ope);
		break;
	case eGRG_MOVING:
		/* Ȃ */
		break;
	case eGRG_SUSPEND:
		/* Ȃ */
		break;
	default:
		/* Ȃ */
		break;
	}
	
	return;
}

/***************************************
 * ́Fgo_ntfyReached
 * F[[ɓB
 * FȂ
 * ߂lFȂ
 ***************************************/
void go_ntfyReached(void) {
	
	switch (garage_status) {
	case eGRG_READY:
		/* N蓾Ȃ */
		break;
	case eGRG_MOVING:
		/* 쓮\Ԃ */
		garage_status = eGRG_READY;
		/* BJudgeR|[lgɒm点 */
		oj_reached();
		break;
	case eGRG_SUSPEND:
		/* N蓾Ȃ */
		break;
	case eGRG_STOP:
		/* N蓾Ȃ */
		break;
	default:
		/* Ȃ */
		break;
	}
	
	return;
}

/***************************************
 * ́Fgo_stopEmergency
 * Fً}~{^ł̒~
 *       ㏸~{^͗LȂ̂ReadyԂֈڍs
 * FȂ
 * ߂lFȂ
 ***************************************/
void go_stopEmergency(void) {
	
	switch (garage_status) {
	case eGRG_READY:
		/* Ȃ */
		break;
	case eGRG_MOVING:
		/* ~iً}~jԂ */
		garage_status = eGRG_STOP;
		/* ~ƂJudgeR|[lgɒm点 */
		oj_stopped();
		break;
	case eGRG_SUSPEND:
		/* Ȃ */
		break;
	case eGRG_STOP:
		/* Ȃ */
		break;
	default:
		/* Ȃ */
		break;
	}
	return;
}

/***************************************
 * ́Fgo_ntfyDetection
 * FӊĎ̌̕o̒ʒm
 * FȂ
 * ߂lFȂ
 ***************************************/
void go_ntfyDetection(void) {
	
	switch (garage_status) {
	case eGRG_READY:
		/* Ȃ */
		break;
	case eGRG_MOVING:
		/* ꎞ~Ԃ */
		garage_status = eGRG_SUSPEND;
		break;
	case eGRG_SUSPEND:
		/* Ȃ */
		break;
	case eGRG_STOP:
		/* Ȃ */
		break;
	default:
		/* Ȃ */
		break;
	}
	
	return;
}

/***************************************
 * ́Fgo_ntfyRemoved
 * FӊĎ̏̒̕ʒm
 * FȂ
 * ߂lFȂ
 ***************************************/
void go_ntfyRemoved(void) {

	switch (garage_status) {
	case eGRG_READY:
		/* Ȃ */
		break;
	case eGRG_MOVING:
		/* Ȃ */
		break;
	case eGRG_SUSPEND:
		/* 쓮\Ԃ */
		garage_status = eGRG_MOVING;
		break;
	case eGRG_STOP:
		/* Ȃ */
		break;
	default:
		/* Ȃ */
		break;
	}
	
	return;
}

/***************************************
 * ́Fgo_dispStatus
 * FݏԂ̕\
 * FȂ
 * ߂lFȂ
 ***************************************/
static void go_dispStatus(void) {
	disp_status_t sts;
	
	switch (garage_status) {
	case eGRG_READY:
		if (ca_isLock() == true) {
			sts = eDSP_LOCK;	/* s̕\ */
		} else {
			sts = eDSP_READY;	/* ҋ@̕\ */
		}
		break;
	case eGRG_MOVING:
		sts = eDSP_RUNNING;		/* 쓮̕\ */
		break;
	case eGRG_SUSPEND:
		sts = eDSP_SUSPEND;		/* ꎞ~̕\ */
		break;
	case eGRG_STOP:
		sts = eDSP_WARNING;		/* x̕\ */
		break;
	default:
		/* bNԂɂ */
		sts = eDSP_LOCK;
		break;
	}
	
	/* ԕ\̎w */
	ds_dispState(sts);

	return;
}
