/*----------------------------------------------------------------------*/
/*t@CF	TimerIntr.h	[ti]										*/
/*	  eF	^C}[										 	*/
/*	  tF	2022.11.08												*/
/*	쐬ҁF	b-slash													*/
/*----------------------------------------------------------------------*/
/*** ATSTASK TimerIntr ***/
/* pR|[lg */
#include "../../drv/OutputDevice/PwmDriver.h"
#include "../../drv/InputDevice/SonarSensor.h"

/* R|[lg */
#include "TimerIntr.h"

/* ESP-IDFCu */
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "driver/gpio.h"

/*** GPTimerp ***/
#include "freertos/queue.h"
#include "driver/gptimer.h"
#include "esp_log.h"
static const char *TAG = "example";
typedef struct {
    uint64_t event_count;
} example_queue_element_t;

/* ^C}[݂̎ */
#define CYCLIC_DURATION	20*100	/* 20mseci10secPʁj */
/*** GPTimerp ܂ ***/

/* ݃nhϐ */
int		g_time_tick = 0;		/* CxgtO */
static	int	time_counter;		/* JE^ */

/* ֐vg^Cv錾 */
static bool periodic_timer_callback(gptimer_handle_t, const gptimer_alarm_event_data_t*, void*);
static void gptimer_init(void);

/***************************************
 * ́Fti_init
 * F^C}[݂̏
 * FȂ
 * ߂lFȂ
 ***************************************/
void ti_init(void) {
	/* GPTimerN iGPTimer for esp-idf v5j */
	gptimer_init();
	
	/* ^C}[ϐ̏ */
	g_time_tick = 0;
	time_counter = 0;
	
	return;
}

/***************************************
 * ́Ftimer0_intr
 * F^C}[݊֐(10ʕbj
 * FȂ
 * ߂lFȂ
 ***************************************/
static bool periodic_timer_callback(gptimer_handle_t timer, const gptimer_alarm_event_data_t *edata,void *user_ctx) {
    BaseType_t high_task_awoken = pdFALSE;
	
	if (time_counter++ >=  CYCLIC_DURATION) {	/* 2000JEg */
		g_time_tick = 1;						/* 20msec (10sec2000JEg) */
		time_counter = 0;
	}
	
	/***** 10sec荞ݏ *****/
	/* PWMo */
	smgr_output_pwm();
	
	/* \i[ZT[ł̌̕o */
	smgr_trig_echo();
	
	return high_task_awoken == pdTRUE;
}

/***************************************
 * ́Fgptimer_init
 * Fn[hEFA^C}ݒEN
 * FȂ
 * ߂lFȂ
 ***************************************/
static void gptimer_init(void) {
    QueueHandle_t queue = xQueueCreate(10, sizeof(example_queue_element_t));

    ESP_LOGI(TAG, "Create timer handle");
    gptimer_handle_t gptimer = NULL;
    gptimer_config_t timer_config = {
        .clk_src = GPTIMER_CLK_SRC_DEFAULT,
        .direction = GPTIMER_COUNT_UP,
        .resolution_hz = 100000, // 1MHz, 1 tick=1us ==> 100KHz 10us
    };
    ESP_ERROR_CHECK(gptimer_new_timer(&timer_config, &gptimer));

    gptimer_alarm_config_t alarm_config = {
        .reload_count = 0, // counter will reload with 0 on alarm event
        .alarm_count = 1, // period = 10us @resolution 100KHz
        .flags.auto_reload_on_alarm = true, // enable auto-reload
    };
    ESP_ERROR_CHECK(gptimer_set_alarm_action(gptimer, &alarm_config));

    gptimer_event_callbacks_t cbs = {
        .on_alarm = periodic_timer_callback,
    };
    ESP_ERROR_CHECK(gptimer_register_event_callbacks(gptimer, &cbs, queue));

    ESP_LOGI(TAG, "Enable timer & Start");
    ESP_ERROR_CHECK(gptimer_enable(gptimer));
    ESP_ERROR_CHECK(gptimer_start(gptimer));

    return;
}
