/*--------------------------------------------------------------*/
/*t@CF	Dealing.c	[dl]								*/
/*	  eF											*/
/*	  tF	2025.12.11										*/
/*	쐬ҁF	b-slash											*/
/*--------------------------------------------------------------*/
/*** ATSTASK MainTask ***/
/* pwb_ */
#include <cstdio>
#include "../ctrl/Money.h"
#include "../ctrl/Goods.h"

/* wb_ */
#include	"Dealing.h"

using namespace std;

/* vg^Cv錾 */
/***************************************
 * ́Finit
 * F
 * FȂ
 * ߂lFȂ
 ***************************************/
CDealing::CDealing(CMoney* mny, CGoods* gds)
{
	theMoney = mny;
	theGoods = gds;
}

void CDealing::init(void) 
{
	/* K̏ */
	theMoney->init();
	
	/* ȉ */
	theGoods->init();

	/* ԕϐ̏ */
	deal_state = eDS_WAITING;
	
	/* wʂ̏ */
	deal_result.goods_id = 0;	
	deal_result.change = 0;
	
	return;
}

/***************************************
 * ́Fdeal
 * Fi̎
 * FȂ
 * ߂lF
 ***************************************/
sDealResult_t CDealing::deal(void) 
{
	int amount = 0;	//add by TianBin
	GoodsInfo_t  rack_goods;	//add by TianBin

	switch (deal_state) {
		case eDS_WAITING:
			/* ̃`FbN */		
			amount += theMoney->checkDeposit();
			deal_result.change = amount;	/* iIO̕ԋz */
			deal_state = eDS_DEALING;	/* ԑJ */
			break;
		case eDS_DEALING:
			/* 7ZO\ */
			theGoods->showGoodID();

			/* ̃`FbN */
			amount += theMoney->checkDeposit();
			deal_result.change = amount;	/* iIO̕ԋz */
			
			/* ԋ̃`FbN */
			if (theMoney->checkRtnChange()){
				deal_result.goods_id = -1;	//ԋ
				deal_result.change = amount;
				deal_state = eDS_RETURN;	/* ԑJ */
			}else{
				/* iĨ`FbN */
				rack_goods = theGoods->goodsSelect();
				if ((rack_goods.goods_id != 0) && (amount >= rack_goods.price)) {
					/*  */
					deal_result.goods_id = rack_goods.goods_id; /* iID */
					deal_result.change = amount - rack_goods.price;
					deal_state = eDS_CLOSED;	/* ԑJ */
				}
			}
			break;
		case eDS_CLOSED:
			/* Ȃ */
			break;
		case eDS_RETURN:
			//wait sometime
			
			break;
		default:
			/* Ȃ */
			break;
		}

		printf("Dealing STATE = %d     goods_id = %d,  change=%d\n", deal_state, deal_result.goods_id, deal_result.change);
		return deal_result;
	}

/***************************************
 * ́Fdl_finish
 * Fi̊
 * FȂ
 * ߂lFȂ
 ***************************************/
// void CDealing::dl_finish(void) 
// {
// 	dl_init();
// 	return;
// }

/***************************************
 * ́Fdl_cancel
 * Fi̎
 * FȂ
 * ߂lF݂̓z
 ***************************************/
// int CDealing::dl_cancel(void) 
// {		
// 	return (deal_result.change);
// }