/*--------------------------------------------------------------*/
/*t@CF	AutoSales.h	[as]								*/
/*	  eF	i̔										*/
/*	  tF	2025.12.11										*/
/*	쐬ҁF	b-slash											*/
/*--------------------------------------------------------------*/
/*** ATSTASK MainTask ***/
/* pwb_ */
#include "../facade/Panel.h"
#include "../facade/MessageWidget.h"
/* DEBUG:ESP-IDFCu */
#include "driver/gpio.h"	/* gpio_get_level, gpio_set_level */
/* wb_ */
#include	"AutoSales.h"

using namespace std;

CAutoSales::CAutoSales(CDealing* dl, CShipment* shpmt, CPanel* pn)
{
	theDealing = dl;
	theShipment = shpmt;
	thePanel = pn;

	init();
}

/***************************************
 * ́Finit
 * F
 * FȂ
 * ߂lFȂ
 ***************************************/
void CAutoSales::init(void) 
{
	/* ̏ */
	theDealing->init();

	/* ȍׂ */
	theShipment->init();

	/* pl̏ */
	thePanel->pn_init();
	
	deal_info.goods_id = 0;
	deal_info.change = 0;

	current_messege_id = 100;

	isShipped = false;
	
	/* ԕϐ̏ */
	sale_state = eSS_WARMUP;

	return;
}

/***************************************
 * ́Frun
 * Fi̔̔iďoׂj
 * FȂ
 * ߂lF
 ***************************************/
void CAutoSales::run(void) 
{		
	int mes_id =  STATE_READY;

	/* mF */
	switch (sale_state) {
	case eSS_WARMUP:	
		sale_state = eSS_READY;	/* ԑJځiȑJځj */
		mes_id = STATE_READY;		/* TBD */
		break;
	case eSS_READY:
		deal_info = theDealing->deal();
		/*  ܂͏iĨ`FbN */
		if ((deal_info.change != 0) || (deal_info.goods_id != 0)) {
			sale_state = eSS_SELLING;	/* TBD */
			mes_id = STATE_SELLING;
		}
		break;
	case eSS_SELLING:		
		deal_info = theDealing->deal();
		/* ԋ̃`FbN */
		if (deal_info.goods_id == -1) {
			mes_id = STATE_COMPLETE;
			theShipment->returnChange(deal_info.change);
			sale_state = eSS_RETURN;
		}else if (deal_info.goods_id > 0) {
				/* o׏Ԃ */
				sale_state = eSS_SHIPPING;
				mes_id = STATE_SHIPPING;		/* TBD */				
		}		
		break;
	case eSS_SHIPPING:
		/* oׂ̎s */
		theShipment->ship(deal_info.goods_id, deal_info.change);					

		/* R[obN֐ł̊ʒm҂ */
		if(isShipped)
		{
			next();
		}
		break;
	case eSS_RETURN:
		/* R[obN֐ł̊ʒm҂ */
		if(isShipped)
		{
			next();
		}		
		break;
	default:
		/* Ȃ */
		break;
	}
	
	if (mes_id != current_messege_id) {;
		current_messege_id = mes_id;
		/* ݏԂ̕\ */
		CMessageWidget::mw_disp_upper(mes_id);		/* TBD */
	}
	
	printf("AutoSales STATE = %d     MES = %d \n", sale_state, current_messege_id);
	return;
}
/***************************************
 * ́Fshipped
 * Foׂ̊
 * FȂ
 * ߂lF
 ***************************************/
void CAutoSales::notifyShipped(void) 
{	
	/* mF */
	isShipped = true;
	return;
}

/***************************************
 * ́FreturnMoney
 * Fԋpv
 * FȂ
 * ߂lFȂ
 ***************************************/
// void CAutoSales::returnMoney(void) 
// {
// 	int change = 0;
// 	/* mF */
// 	switch (sale_state) {
// 	case eSS_SELLING:
// 		change = theDealing->dl_cancel();
// 		if (change != 0) {
// 			/* Εԋp */
// 			sale_state = eSS_RETURN;
			
// 			theShipment->returnChange(change);
// 		}
// 		break;
// 	default:
// 		/* Ȃ */
// 		break;
// 	}
	
// 	return;
// }

/***************************************
 * ́Fnext
 * F̎
 * FȂ
 * ߂lFȂ
 ***************************************/
void CAutoSales::next(void) 
{
	/* o׊ŁAғԂ */
	//sale_state = eSS_READY;
	
	// /* ̊ */
	// theDealing->dl_finish();	

	/* ̏ */	
	//theDealing->init();

	init();

	return;
}
