/*--------------------------------------------------------------*/
/*t@CF	SimFactory.c [sf]								*/
/*	  eF	V~[^̏							*/
/*	  tF	2025.12.11										*/
/*	쐬ҁF	b-slash											*/
/*--------------------------------------------------------------*/
/*** ATSTASK Simulator ***/
/* pwb_ */
#include "../drv/ToggleDrv.h"

#include "../biz/AutoSales.h"
#include "../biz/Dealing.h"
#include "../biz/Shipment.h"
#include "../ctrl/Change.h"
#include "../ctrl/Goods.h"
#include "../ctrl/Money.h"
#include "../ctrl/SelectedGoods.h"
#include "../facade/Panel.h"

/* wb_ */
#include "SimFactory.h"


// ========================================================
// File    : main.c
// Role    : Sample12 print strings
// Update  : 2024.12.16 (delete projectTimer)
// Date    : 2024.12.11
// Author  : Em
// ========================================================
// --- Header files (project)
#include "../drv/sevenSegmentLed.h"
#include "../drv/pushButton.h"
#include "../drv/lcd.h"
#include "../drv/printLcd.h"

//static const char	machine[]	= "Vend Simulator";

// --- prototypes (static)
//static void	initialize(void);
// ========================================================


/* 񋓑̂̒` */

/* ϐ` */
std::map<std::string, std::any> CSimFactory::myMap;

/* vg^Cv錾 */
void CSimFactory::productInstances(void){
	CPanel* pn = new CPanel();
	//---------------------------------
	CMoney* mny = new CMoney();
	CGoods* gds = new CGoods();

	CSelectedGds* sgd = new CSelectedGds();
	CChange* cg = new CChange();

	CDealing* dl = new CDealing(mny, gds);
    CShipment* shpmt = new CShipment(sgd,cg);
	sgd->theShipment = shpmt;
	cg->theShipment = shpmt;

	cg->stp_instance = cg;

	CAutoSales* theAutoSales = new CAutoSales(dl, shpmt, pn);
	shpmt->theAutoSales = theAutoSales;

	
	myMap["CPanel"] = pn;
	myMap["CAutoSales"] = theAutoSales;
}

std::any getInstance(const std::string& name) {
    // if(myMap.find(name) != myMap.end()) 
	// {
    //     return myMap[name].get();
    // }
    return nullptr;
}

/***************************************
 * ́Fsf_init
 * F
 * FȂ
 * ߂lFȂ
 ***************************************/
void CSimFactory::sf_init(void) {
		
	/* gOXCb`̏ */
	CToggleDrv::td_init();

// ========================================================
	// initialize devices
	//sv_init();
	CPushButton::pb_init();
	CLcd::lcd_init();

	//pr_lcd_init();
	//pr_lcd_clear();
	//pr_lcd_setcursor(PR_LCD_LEFT, PR_LCD_UPPER);
	////pr_lcd_puts(author);
	//pr_lcd_puts(machine);
	/* LCDo */
	//pr_lcd_output();	// output from buffer to LCD
	
// ========================================================
	
	return;
}

