/*--------------------------------------------------------------*/
/*t@CF	Dealing.c	[dl]								*/
/*	  eF											*/
/*	  tF	2025.12.11										*/
/*	쐬ҁF	b-slash											*/
/*--------------------------------------------------------------*/
/*** ATSTASK MainTask ***/
/* pwb_ */
#include "../ctrl/Money.h"
#include "../ctrl/Goods.h"

/* wb_ */
#include	"Dealing.h"

/* 񋓑̂̒` */
/* Ԃ̒` */
typedef enum {
	eDS_WAITING = 0,	/* ҂ */
	eDS_DEALING,		/*  */
	eDS_CLOSED,			/*  */
	eDS_RETURN			/* ԋp */
} eDealStatus_t;

/* ϐ` */
static eDealStatus_t	deal_state;		/*  */
static sDealResult_t	deal_result;	/*  */

/* vg^Cv錾 */

/***************************************
 * ́Fdl_init
 * F
 * FȂ
 * ߂lFȂ
 ***************************************/
void dl_init(void) {
	
	/* K̏ */
	my_init();
	
	/* ȉ */
	gd_init();
	
	/* ԕϐ̏ */
	deal_state = eDS_WAITING;
	
	/* wʂ̏ */
	deal_result.goods_id = 0;	
	deal_result.change = 0;
	
	return;
}

/***************************************
 * ́Fdl_deal
 * Fi̎
 * FȂ
 * ߂lF
 ***************************************/
sDealResult_t dl_deal(void) {

	switch (deal_state) {
	case eDS_WAITING:
	case eDS_DEALING:
		/* ̎s */
		int amount = my_deposit();
		deal_result.change = amount;	/* iIO̕ԋz */
		
		/* iI̎s */
		GoodsInfo_t  rack_goods = gd_select();
		int price = rack_goods.price;
		
		if ((price != 0)
		   && (amount >= price)) {
			/*  */
			deal_state = eDS_CLOSED;	/* ԑJ */
			deal_result.change = amount - price;
			deal_result.goods_id = rack_goods.goods_id; /* iID */
		}
		break;
	case eDS_CLOSED:
		/* Ȃ */
		break;
	case eDS_RETURN:
		/* Ȃ */
		break;
	default:
		/* Ȃ */
		break;
	}
	
	return deal_result;
}

/***************************************
 * ́Fdl_finish
 * Fi̊
 * FȂ
 * ߂lFȂ
 ***************************************/
void dl_finish(void) {

	switch (deal_state) {
	case eDS_WAITING:
	case eDS_DEALING:
		/* Ȃ */
		break;
	case eDS_CLOSED:
		deal_state = eDS_WAITING;	/* ԑJ */
		break;
	case eDS_RETURN:
		/* Ȃ */
		break;
	default:
		/* Ȃ */
		break;
	}
	
	return;
}

/***************************************
 * ́Fdl_cancel
 * Fi̎
 * FȂ
 * ߂lF݂̓z
 ***************************************/
int dl_cancel(void) {
	
	
	return (deal_result.change);
}

