/*--------------------------------------------------------------*/
/*t@CF	AutoSales.h	[as]								*/
/*	  eF	i̔										*/
/*	  tF	2025.12.11										*/
/*	쐬ҁF	b-slash											*/
/*--------------------------------------------------------------*/
/*** ATSTASK MainTask ***/
/* pwb_ */
#include "Dealing.h"
#include "Shipment.h"
#include "../facade/Panel.h"
#include "../facade/MessageWidget.h"

/* wb_ */
#include	"AutoSales.h"


/* DEBUG:ESP-IDFCu */
#include "driver/gpio.h"	/* gpio_get_level, gpio_set_level */

/* 񋓑̂̒` */
/* ̔Ԃ̒` */
typedef enum {
	eSS_WARMUP = 0,		/*  */
	eSS_READY,			/* ғ */
	eSS_SELLING,		/* ̔ */
	eSS_SHIPPING,		/* oג */
	eSS_RETURN			/* ԋp */
} eSaleStatus_t;

/* ϐ` */
static eSaleStatus_t sale_state;	/* ̔ */
static sDealResult_t deal_info;		/* ʁAiIDƂނj*/
static int current_messege_id;		/* ݂̃bZ[Wԍ*/

/* vg^Cv錾 */
static void as_next(void);

/***************************************
 * ́Fas_init
 * F
 * FȂ
 * ߂lFȂ
 ***************************************/
void as_init(void) {
	
	/* ̏ */
	dl_init();
	
	/* ȍׂ */
	sp_init();
	
	/* pl̏ */
	pn_init();
	
	/* ԕϐ̏ */
	sale_state = eSS_WARMUP;
	
	deal_info.goods_id = 0;
	deal_info.change = 0;

	current_messege_id = 100;
	return;
}

/***************************************
 * ́Fas_run
 * Fi̔̔iďoׂj
 * FȂ
 * ߂lF
 ***************************************/
void as_run(void) {
	
	int mes_id =  STATE_READY;
	
	/* READYSALE̎Ɏs */
	if ((sale_state == eSS_READY) || (sale_state == eSS_SELLING)) {
		/* ̎s */
		deal_info = dl_deal();
	}
	
	/* mF */
	switch (sale_state) {
	case eSS_WARMUP:
		
		/* ̔̏ */
		as_init();
		sp_init();	/* ȍׂ */
		
		sale_state = eSS_READY;	/* ԑJځiȑJځj */
		mes_id = STATE_READY;		/* TBD */
		break;
	case eSS_READY:
		if ((deal_info.change != 0) || (deal_info.goods_id != 0)) {
			sale_state = eSS_SELLING;	/* TBD */
			mes_id = STATE_SELLING;	/* TBD */
		}
		break;
	case eSS_SELLING:
		if (deal_info.goods_id != 0) {
			/* o׏Ԃ */
			sale_state = eSS_SHIPPING;
			mes_id = STATE_MATCH;		/* TBD */
			
			/* oׂ̎s */
			sp_ship(deal_info.goods_id, deal_info.change);
		}
		break;
	case eSS_SHIPPING:
		/* Ȃ */
		/* R[obN֐ł̊ʒm҂ */
		break;
	case eSS_RETURN:
		/* Ȃ */
		break;
	default:
		/* Ȃ */
		break;
	}
	
	if (mes_id != current_messege_id) {;
		current_messege_id = mes_id;
		/* ݏԂ̕\ */
		mw_disp_upper(mes_id);		/* TBD */
	}
	
	printf("SALE STATE = %d     MES = %d \n", sale_state, current_messege_id);
	return;
}
/***************************************
 * ́Fas_shipped
 * Foׂ̊
 * FȂ
 * ߂lF
 ***************************************/
void as_shipped(void) {
	
	/* mF */
	switch (sale_state) {
	case eSS_WARMUP:
		/* Ȃ */
		break;
	case eSS_READY:
		/* Ȃ */
		break;
	case eSS_SELLING:
		/* Ȃ */
		break;
	case eSS_SHIPPING:
		/* o׊ŁA̎ */
		as_next();
		
		break;
	case eSS_RETURN:
		/* Ko͊ŁA̎ */
		as_next();
		break;
	default:
		/* Ȃ */
		break;
	}
	
	return;
}

/***************************************
 * ́Fas_return
 * Fԋpv
 * FȂ
 * ߂lFȂ
 ***************************************/
void as_return(void) {
	
	/* mF */
	switch (sale_state) {
	case eSS_WARMUP:
		/* Ȃ */
		break;
	case eSS_READY:
		/* Ȃ */
		break;
	case eSS_SELLING:
		int change = dl_cancel();
		if (change != 0) {
			/* Εԋp */
			sale_state =eSS_RETURN;
			
			sp_return(change);
		}
		break;
	case eSS_SHIPPING:
		/* Ȃ */
		break;
	case eSS_RETURN:
		/* Ȃ */
		break;
	default:
		/* Ȃ */
		break;
	}
	
	return;
}

/***************************************
 * ́Fas_next
 * F̎
 * FȂ
 * ߂lFȂ
 ***************************************/
static void as_next(void) {
	
	/* o׊ŁAғԂ */
	//sale_state = eSS_READY;
	sale_state = eSS_WARMUP;
	/* ̊ */
	dl_finish();
	/* ̏ */	
	dl_init();
	
	return;
}
